%%

% Aproximamos la solucion de la ecuacion diferencial 
%
%    d²u
%    --- - u = -x, 0 < x < 1
%    dx²
%
% con condiciones de contorno u(0)=u(1)=0.
%
% Nos referiremos al operador diferencial que aparece en la ecuacion como
% L.
%
%    d²u
%    --- - u = L(u)
%    dx²
%
% La ecuacion sera representada por 
% 
%             L(u) = f, 
% con f(x) = -x.
%
% La solucion analitica es 'x-sinh(x)/sinh(1)'

uan = @(x) x-sinh(x)/sinh(1.0);
ezplot(uan,[0,1]);

%

% primera funcion de prueba y el resultado de aplicarle el operador 
% diferencial de la ecuacion

% funcion 'f' en la ecuacion
fec = @(x) (-x);

% funciones test
ut1  = @(x) x.*(1.0-x);
ut2  = @(x) x.^2 .* (1.0-x)  ;

% resultado de calcular el L sobre a las funciones test
Lut1 = @(x) -2.0 - ut1(x) ;
Lut2 = @(x)  2.0*( 1.0 - 3*x ) - ut2(x);

% funciones peso para minimos cuadrados (dR/da), lo cual se reduce a 
% L(u).
wmc1 = Lut1;
wmc2 = Lut2;

% funciones peso para Galerkin
wg1 = ut1;
wg2 = ut2;

%% METODO DE MINIMOS CUADRADOS CON UNA UNICA FUNCION TEST
Imc1 = @(a) quad( @(x) wmc1(x).*( a*Lut1(x)-fec(x) ), 0,1);
amc1 = fzero(Imc1,0);
x = 0:0.05:1;
figure(1);clf;
plot(x,uan(x),'-b',x, amc1*ut1(x),'ro');

%% METODO DE GALERKIN CON UNA UNICA FUNCION TEST
Ig1 =  @(a) quad( @(x) wg1(x).*( a*Lut1(x)-fec(x) ), 0,1);
ag1 = fzero(Ig1,0);
hold on; plot(x, ag1*ut1(x),'*g');

%% %METODO DE MINIMOS CUADRADOS CON DOS FUNCIONES TEST
mmc2 = [ quad( @(x) wmc1(x) .* Lut1(x), 0, 1) , ...
         quad( @(x) wmc2(x) .* Lut1(x), 0, 1) ;
         quad( @(x) wmc1(x) .* Lut2(x), 0, 1) , ...
         quad( @(x) wmc2(x) .* Lut2(x), 0, 1) ];
     
bmc2 = [ quad( @(x) wmc1(x) .* fec(x) , 0, 1) ; 
         quad( @(x) wmc2(x) .* fec(x) , 0, 1) ];

amc2 = mmc2\bmc2;

figure(2);clf;
plot(x,uan(x),'-b',x, amc2(1)*ut1(x)+amc2(2)*ut2(x),'ro'); hold on;

%% METODO DE GALERKIN CON DOS FUNCIONES TEST
mg2 = [ quad( @(x) wg1(x) .* Lut1(x), 0, 1) , ...
        quad( @(x) wg2(x) .* Lut1(x), 0, 1) ;
        quad( @(x) wg1(x) .* Lut2(x), 0, 1) , ...
        quad( @(x) wg2(x) .* Lut2(x), 0, 1) ];
     
bg2 = [ quad( @(x) wg1(x) .* fec(x) , 0, 1) ; 
        quad( @(x) wg2(x) .* fec(x) , 0, 1) ];

ag2 = mg2\bg2;
plot(x, ag2(1)*ut1(x)+ag2(2)*ut2(x),'*g');
hold off;

%%

%%
% funciones continuas a trozos
%
clear; clf;

% solucion analitica
uan = @(x) x-sinh(x)/sinh(1.0);

% limites de integracion

xa = 0.0;
xb = 1.0;

% funciones test

phi1  = @(x) triangle(x,[0 1./3. 2./3.]);
dphi1 = @(x) dertriangle(x,[0 1./3. 2./3.]);
phi2  = @(x) triangle(x,[1./3. 2./3. 1.]);
dphi2 = @(x) dertriangle(x,[1./3. 2./3. 1.]);


% funciones peso

wg1 = phi1;
dwg1 = dphi1;
wg2 = phi2;
dwg2 = dphi2;

% matriz del sistema de ecuaciones

mg = zeros(2,2);

mg(1,1) = integral1(phi1,dphi1,wg1,dwg1,xa,xb);
mg(1,2) = integral1(phi1,dphi1,wg2,dwg2,xa,xb);
mg(2,1) = integral1(phi2,dphi2,wg1,dwg1,xa,xb);
mg(2,2) = integral1(phi2,dphi2,wg2,dwg2,xa,xb);

% el termino independiente del sistema de ecuaciones es el mismo 
% que en los casos anteriores (-x*w(x)).

% funcion 'f' en la ecuacion
fec = @(x) (-x);

bg = [ quad( @(x) wg1(x) .* fec(x) , xa, xb) ; 
        quad( @(x) wg2(x) .* fec(x) , xa, xb) ];

% resolvemos el sistema de ecuaciones y dibujamos las funciones resultantes
figure;
ag = mg\bg;
x = linspace(0,1,25);
plot(x, ag(1)*phi1(x)+ag(2)*phi2(x),'*g',x,uan(x),'-b',...
     x, ag(1)*phi1(x), '-g',x,ag(2)*phi2(x),'-r');
 
%%
% elementos finitos
%
clear; clf;

% solucion analitica
uan = @(x) x-sinh(x)/sinh(1.0);

% limites de integracion

xa = 0.0;
xb = 1.0;

% numero de elementos  x---x---x---x---x---x
%                     xa=x(1)             xb=x(2)
%


n = 6;
x = linspace( xa, xb, n+2);
mg = zeros(n,n);
bg = zeros(n,1);
% funcion 'f' en la ecuacion
fec = @(x) (-x);

% malla extendida, definida por conveniencia para los elementos de los
% extremos (a los que le falta un lado del triangulo).
%xx = [ x(1)-(x(2)-x(1)), x, x(n) + (x(n)-x(n-1))];


for ii = 1:n
    wg1  = @(t)    triangle( t, [ x(ii), x(ii+1), x(ii+2)]);
    dwg1 = @(t) dertriangle( t, [ x(ii), x(ii+1), x(ii+2)]);
    bg(ii) = quad( @(t) wg1(t) .* fec(t) , xa, xb);
    for jj=1:n
        wg2  = @(t)    triangle( t, [ x(jj), x(jj+1), x(jj+2)]);
        dwg2 = @(t) dertriangle( t, [ x(jj), x(jj+1), x(jj+2)]);
        mg(ii,jj) = integral1( wg1, dwg1, wg2, dwg2, xa, xb);
    end
end


ag = linsolve(mg,bg);
% Redefinimos x para dibujarlo
xp = linspace( xa, xb, 25); 
plot( xp, uan(xp), '-b', x(2:end-1), ag,'or');
hold on;
for ii=1:n
    wg1  = @(t)    triangle( t, [ x(ii), x(ii+1), x(ii+2)]);
    plot( x, ag(ii)*wg1(x),'g-');    
end
hold off;

%%

% version analitica de la seccion anterior

% limites de integracion

xa = 0.0;
xb = 1.0;

% numero de elementos

n = 7;

x = linspace( xa, xb, n+2);
dx = x(2)-x(1);

% matriz de masa

ds = ones( 1, n-1)*dx/6.0;
dd = ones( 1, n)*dx*2.0/3.0;
di = ones( 1, n-1)*dx/6.0;

M = diag( ds, 1) + diag( dd, 0) + diag( di, -1);

% matriz de rigidez

ds = -ones( 1, n-1)*(1.0/dx);
dd =  ones( 1, n)*(2.0/dx);
di = -ones( 1, n-1)*(1.0/dx);

K = diag( ds, 1) + diag( dd, 0) + diag( di, -1);

% vector B

B = (1:n)';
B = dx^2 * B;

C = (M+K)\B;

xx = linspace( xa, xb, 25);
plot(xx, xx-sinh(xx)/sinh(1.0),'b-', x(2:end-1), C, 'ro');
